<?php
require_once( __DIR__ . DIRECTORY_SEPARATOR . 'php_form.php' );

if ( !function_exists( 'formatDate' ) ) {
	function formatDate($entryDate, $inputFormat = 'Y-m-d', $outputFormat = 'd/m/Y') {
		if (in_array($entryDate, ['0000-00-00', '0000-00-00 00:00:00', '00/00/0000', '0', null, ''])) {
			return '';
		}
		$date = DateTime::createFromFormat($inputFormat, $entryDate);

		if (!$date || DateTime::getLastErrors()['warning_count'] > 0 || DateTime::getLastErrors()['error_count'] > 0) {
			return $entryDate;
		}
		return $date->format($outputFormat);
	}
}

if ( !function_exists( 'getDicoByName' ) ) {
	function getDicoByName ( $dicoName ) {
		$sql = 'SELECT
					dico_value,
					dico_label
				FROM
					dico
				WHERE
					dico_name = ' . quote( $dicoName ) . '
				AND dico_active = 1
				ORDER BY
					dico_order ASC';
		return get_results( $sql, true );
	}
}
