<?php

class DefaultModel implements ArrayAccess {
	public function check ( $post, $files ) {
		return true;
	}
	
	public function save ( $post, $files ) {
		return true;
	}
	
	protected $datas = [];
	
	public function __construct ( $datas = [] ) {
		$this->setDatas( $datas );
	}
	
	public function get ( $offset ) {
		if ( array_key_exists( $offset, $this->datas ) ) {
			return $this->datas[ $offset ];
		}
	}
	
	public function set ( $offset, $value ) {
		return $this->datas[ $offset ] = $value;
	}
	
	public function getData ( $offset ) {
		return $this->get( $offset );
	}
	
	public function getDatas () {
		return $this->datas;
	}
	
	public function setDatas ( $datas ) {
		$this->datas = $datas;
	}
	
	/***********************************************************************************************
	 * PHP magic's function. Return get method
	 * @param $offset (string) key you want to get
	 * @return misc
	 */
	public function __get ( $offset ) {
		return $this->get( $offset );
	}
	
	/***********************************************************************************************
	 * PHP magic's function. Return set method
	 * @param $offset (string) key you want to set
	 * @param $value (misc)    value of the variable
	 * @return misc
	 */
	public function __set ( $offset, $value ) {
		return $this->set( $offset, $value );
	}
	
	/***********************************************************************************************
	 * Method implemented by ArrayAccess interface. Check if a key exists
	 * @param $offset (string) key you want to set
	 * @return misc
	 */
    public function offsetExists ( mixed $offset ):Bool {
		return array_key_exists( $offset, $this->datas );
    }
	
	/***********************************************************************************************
	 * Method implemented by ArrayAccess interface. Unset the key
	 * @param $offset (string) key you want to unset
	 */
    public function offsetUnset ( mixed $offset ):void {
		if ( array_key_exists( $offset, $this->datas ) ) {
			unset( $this->values[ $offset ] );
		}
    }
	
	/***********************************************************************************************
	 * Method implemented by ArrayAccess interface. Return get method.
	 * @param $offset (string) key you want to get
	 * @return misc
	 */
    public function offsetGet ( mixed $offset ):mixed {
        return $this->get( $offset );
    }
	
	/***********************************************************************************************
	 * Method implemented by ArrayAccess interface. Return set method.
	 * @param $offset (string) key you want to set
	 * @param $value (misc)    value of the variable
	 * @return misc
	 */
    public function offsetSet ( mixed $offset, mixed $value ):void {
		$this->set( $offset, $value );
    }
}
