<?php
require_once( __DIR__ . DIRECTORY_SEPARATOR . 'conf.inc.php' );

class CinpMysqli extends mysqli {
	public function query ( string $query, int $result_mode = MYSQLI_STORE_RESULT ): mysqli_result|bool {
		try {
			return call_user_func_array( [ 'mysqli', 'query' ], func_get_args() );
		} catch ( Exception $e ) {
			error_log( (string)$e );
			return false;
		}
	}
}

class MySQLiContainer extends SplObjectStorage {
	public function newConnection ( $host = null, $username = null, $passwd = null, $dbname = null, $port = null, $socket = null ) {
		$dbconnection = new CinpMysqli( $host, $username, $passwd, $dbname, $port, $socket );
		if ( mysqli_connect_errno() ) {
			error_log( 'Erreur de connexion mysql : ' . mysqli_connect_errno() . ' : ' . mysqli_connect_error() );
		}else{
			$dbconnection->query( 'SET NAMES utf8mb4' );
			$this->attach( $dbconnection );
			return $dbconnection;
		}
	}
}

$mysqliContainer = new MySQLiContainer();
$mysqli = $mysqliContainer->newConnection( $dbHost, $dbUser, $dbPass, $dbName );


function quote ( $text ) {
	global $mysqli;
	return '"' . $mysqli->real_escape_string( $text ) . '"';
}

function get_var ( $sql ) {
	global $mysqli;
	
	$retval = '';
	if ( trim( $sql ) !== '' ) {
		$rs = $mysqli->query( $sql );
		if ( $rs ) {
			if ( (int)$rs->num_rows > 0 ) {
				$r = $rs->fetch_row();
				$retval = $r[ 0 ];
				$rs->close();
			}
		} else {
			$trace = debug_backtrace();
			error_log( 'Query from file ' . $trace[ 0 ][ 'file' ] . ' (l. ' . $trace[ 0 ][ 'line' ] . ')' );
			error_log( 'Query : ' . $sql );
			error_log( $mysqli->error );
		}
	}
	
	return $retval;
}

function get_vars ( $sql ) {
	global $mysqli;
	
	$retval = [];
	if ( trim( $sql ) !== '' ) {
		$rs = $mysqli->query( $sql );
		if ( $rs ) {
			if ( (int)$rs->num_rows > 0 ) {
				while ( $r = $rs->fetch_array() ) {
					$retval[] = $r[ 0 ];
				}
				$rs->close();
			}
		} else {
			$trace = debug_backtrace();
			error_log( 'Query from file ' . $trace[ 0 ][ 'file' ] . ' (l. ' . $trace[ 0 ][ 'line' ] . ')' );
			error_log( 'Query : ' . $sql );
			error_log( $mysqli->error );
		}
	}
	return $retval;
}

function get_row ( $sql, $assoc = false ) {
	global $mysqli;
	
	if ( $assoc ) {
		$retval = [];
	} else {
		$retval = new stdClass();
	}
	
	if ( trim( $sql ) !== '' ) {
		$rs = $mysqli->query( $sql );
		if ( $rs ) {
			if ( (int)$rs->num_rows > 0 ) {
				if ( $assoc ) {
					$retval = $rs->fetch_assoc();
				} else {
					$retval = $rs->fetch_object();
				}
				$rs->close();
			}
		} else {
			$trace = debug_backtrace();
			error_log( 'Query from file ' . $trace[ 0 ][ 'file' ] . ' (l. ' . $trace[ 0 ][ 'line' ] . ')' );
			error_log( 'Query : ' . $sql );
			error_log( $mysqli->error );
		}
	}
	return $retval;
}

function get_results ( $sql, $assoc = false ) {
	global $mysqli;
	
	$retval = [];
	if ( trim( $sql ) !== '' ) {
		$rs = $mysqli->query( $sql );
		if ( $rs ) {
			if ( (int)$rs->num_rows > 0 ) {
				if ( $assoc ) {
					while ( $r = $rs->fetch_assoc() ) {
						$retval[] = $r;
					}
				}else{
					while ( $r = $rs->fetch_object() ) {
						$retval[] = $r;
					}
				}
				$rs->close();
			}
		} else {
			$trace = debug_backtrace();
			error_log( 'Query from file ' . $trace[ 0 ][ 'file' ] . ' (l. ' . $trace[ 0 ][ 'line' ] . ')' );
			error_log( 'Query : ' . $sql );
			error_log( $mysqli->error );
		}
	}
	return $retval;
}

function dbQuery ( $sql ) {
	global $mysqli;
	
	$rs = $mysqli->query( $sql );
	if ( $rs ) {
		return true;
	} else {
		$trace = debug_backtrace();
		error_log( 'Query from file ' . $trace[ 0 ][ 'file' ] . ' (l. ' . $trace[ 0 ][ 'line' ] . ')' );
		error_log( 'Query : ' . $sql );
		error_log( $mysqli->error );
		file_put_contents( '/tmp/phplog.log', $sql );
	}
	return false;
}

function dbInsert ( $table, $values, $quote = true ) {
	global $mysqli;
	if ( $quote ) {
		$values = array_map( function ( $v ) {
			if ( is_null( $v ) ) {
				return 'NULL';
			} else {
				return quote( $v );
			}
		}, $values );
	}
	
	$sql = 'INSERT INTO `' . $table . '` (
			`' . implode( '`, `', array_keys( $values ) ) . '`
		) VALUES (
			' . implode( ', ', array_values( $values ) ) . '
		)';
	
	dbQuery( $sql );
	return dbLastID();
}

function dbUpdate ( $table, $values, $where, $quote = true ) {
	if ( $quote ) {
		$values = array_map( function ( $v ) {
			if ( is_null( $v ) && ( $v !== '' ) ) {
				return 'NULL';
			} else {
				return quote( $v );
			}
		}, $values );
	}
	
	$sql = 'UPDATE `' . $table . '` SET
				' . implode( ',' . PHP_EOL, array_map( function ( $key, $value ) {
					return $key . ' = ' . $value;
				}, array_keys( $values ), array_values( $values ) ) ) . '
			WHERE ' . $where;
	
	return dbQuery( $sql );
}

function dbDelete ( $table, $where ) {
	$sql = 'DELETE FROM `' . $table . '` WHERE ' . $where;
	return dbQuery( $sql );
}

function dbLastID () {
	global $mysqli;
	return $mysqli->insert_id;
}
