<?php
function createNewWidget ( $widgetDef ) {
	$callback = getWidgets()[ $widgetDef[ 'widget' ] ][ 'callback_generator' ];
	return $callback( $widgetDef );
}

function createHN ( $widgetDef ) {
	$ret = [
		'type'	=> $widgetDef[ 'widget' ],
		'label'	=> $widgetDef[ 'label' ],
	];
	
	if ( !empty( $widgetDef[ 'row_class' ] ) ) {
		$ret[ 'row_class' ] = $widgetDef[ 'row_class' ];
	}
	if ( !empty( $widgetDef[ 'input_class' ] ) ) {
		$ret[ 'input_class' ] = $widgetDef[ 'input_class' ];
	}
	if ( !empty( $widgetDef[ 'label_class' ] ) ) {
		$ret[ 'label_class' ] = $widgetDef[ 'label_class' ];
	}
	
	$attrs = [];
	if ( !empty( $widgetDef[ 'attributes-key' ] ) ) {
		foreach ( $widgetDef[ 'attributes-key' ] as $key => $null ) {
			if ( empty( $widgetDef[ 'attributes-key' ][ $key ] ) ) {
				continue;
			}
			$attrs[ $widgetDef[ 'attributes-key' ][ $key ] ] = $widgetDef[ 'attributes-value' ][ $key ];
		}
	}
	if ( !empty( $widgetDef[ 'data-show-field' ] ) && !empty( $widgetDef[ 'data-show-value' ] ) ) {
		$attrs[ 'data-show-field' ] = $widgetDef[ 'data-show-field' ];
		$attrs[ 'data-show-value' ] = $widgetDef[ 'data-show-value' ];
	}
	if ( !empty( $attrs ) ) {
		$ret[ 'attributes' ] = $attrs;
	}
	
	return $ret;
}

function createText ( $widgetDef ) {
	$ret = [
		'type'	=> $widgetDef[ 'widget' ],
	];
	
	foreach ( [ 'row_class', 'prepend', 'append', 'label', 'name' ] as $exists ) {
		if ( !empty( $widgetDef[ $exists ] ) ) {
			$ret[ $exists ] = $widgetDef[ $exists ];
		}
	}
	
	if ( isset( $widgetDef[ 'mandatory' ] ) && ( (int)$widgetDef[ 'mandatory' ] === 1 ) ) {
		$ret[ 'mandatory' ] = true;
	}
	if ( !empty( $widgetDef[ 'input_class' ] ) ) {
		$ret[ 'input_class' ] = $widgetDef[ 'input_class' ];
	}
	if ( !empty( $widgetDef[ 'label_class' ] ) ) {
		$ret[ 'label_class' ] = $widgetDef[ 'label_class' ];
	}
	
	$attrs = [];
	if ( !empty( $widgetDef[ 'attributes-key' ] ) ) {
		foreach ( $widgetDef[ 'attributes-key' ] as $key => $null ) {
			if ( empty( $widgetDef[ 'attributes-key' ][ $key ] ) ) {
				continue;
			}
			$attrs[ $widgetDef[ 'attributes-key' ][ $key ] ] = $widgetDef[ 'attributes-value' ][ $key ];
		}
	}
	if ( !empty( $widgetDef[ 'data-show-field' ] ) && !empty( $widgetDef[ 'data-show-value' ] ) ) {
		$attrs[ 'data-show-field' ] = $widgetDef[ 'data-show-field' ];
		$attrs[ 'data-show-value' ] = $widgetDef[ 'data-show-value' ];
	}
	if ( !empty( $attrs ) ) {
		$ret[ 'attributes' ] = $attrs;
	}
	
	return $ret;
}

function createRadio ( $widgetDef ) {
	$ret = createText( $widgetDef );
	
	if ( $widgetDef[ 'type_values' ] === 'liste' ) {
		$values = [];
		foreach ( $widgetDef[ 'field_values-key' ] as $key => $null ) {
			if ( ( empty( $widgetDef[ 'field_values-key' ][ $key ] ) && ( $widgetDef[ 'field_values-key' ][ $key ] !== '0' ) ) || empty( $widgetDef[ 'field_values-value' ][ $key ] ) ) {
				continue;
			}
			
			$values[ $widgetDef[ 'field_values-key' ][ (string)$key ] ] = $widgetDef[ 'field_values-value' ][ $key ];
		}
		
		$ret[ 'values' ] = $values;
	} else if ( $widgetDef[ 'type_values' ] === 'dico' ) {
		$ret[ 'dico' ] = $widgetDef[ 'dico_name' ];
	} else if ( $widgetDef[ 'type_values' ] === 'callback' ) {
		$ret[ 'callback' ] = $widgetDef[ 'callback_name' ];
	} else {
		$widgetDef[ 'type_values' ] = 'liste';
	}
	
	return $ret;
}

function createAutocomplete ( $widgetDef ) {
	$ret = createText( $widgetDef );
	
	if ( !empty( $widgetDef[ 'data-url' ] ) ) {
		$ret[ 'attributes' ][ 'data-url' ] = $widgetDef[ 'data-url' ];
	}
	
	$postParams = [];
	if ( !empty( $widgetDef[ 'data-params-key' ] ) ) {
		foreach ( $widgetDef[ 'data-params-key' ] as $key => $null ) {
			if ( empty( $widgetDef[ 'data-params-key' ][ $key ] ) ) {
				continue;
			}
			$postParams[ $widgetDef[ 'data-params-key' ][ $key ] ] = $widgetDef[ 'data-params-value' ][ $key ];
		}
		
		$ret[ 'attributes' ][ 'data-params' ] = $postParams;
	}
	
	if ( !empty( $widgetDef[ 'data-search-callback' ] ) ) {
		$ret[ 'attributes' ][ 'data-search-callback' ] = $widgetDef[ 'data-search-callback' ];
	}
	
	if ( !empty( $widgetDef[ 'data-change-callback' ] ) ) {
		$ret[ 'attributes' ][ 'data-change-callback' ] = $widgetDef[ 'data-change-callback' ];
	}
	
	return $ret;
}

function createButtons ( $widgetDef ) {
	$ret = [
		'type'	=> $widgetDef[ 'widget' ],
	];
	
	if ( !empty( $widgetDef[ 'row_class' ] ) ) {
		$ret[ 'row_class' ] = $widgetDef[ 'row_class' ];
	}
	if ( !empty( $widgetDef[ 'input_class' ] ) ) {
		$ret[ 'input_class' ] = $widgetDef[ 'input_class' ];
	}
	if ( !empty( $widgetDef[ 'label_class' ] ) ) {
		$ret[ 'label_class' ] = $widgetDef[ 'label_class' ];
	}
	
	$attrs = [];
	if ( !empty( $widgetDef[ 'attributes-key' ] ) ) {
		foreach ( $widgetDef[ 'attributes-key' ] as $key => $null ) {
			if ( empty( $widgetDef[ 'attributes-key' ][ $key ] ) ) {
				continue;
			}
			$attrs[ $widgetDef[ 'attributes-key' ][ $key ] ] = $widgetDef[ 'attributes-value' ][ $key ];
		}
	}
	if ( !empty( $widgetDef[ 'data-show-field' ] ) && !empty( $widgetDef[ 'data-show-value' ] ) ) {
		$attrs[ 'data-show-field' ] = $widgetDef[ 'data-show-field' ];
		$attrs[ 'data-show-value' ] = $widgetDef[ 'data-show-value' ];
	}
	if ( !empty( $attrs ) ) {
		$ret[ 'attributes' ] = $attrs;
	}
	
	$content = [];
	if ( !empty( $widgetDef[ 'content-key' ] ) ) {
		foreach ( $widgetDef[ 'content-key' ] as $i => $null ) {
			if ( empty( $widgetDef[ 'content-key' ][ $i ] ) || empty( $widgetDef[ 'content-value' ][ $i ] ) ) {
				continue;
			}
			$content[] = [
				'label'	=> $widgetDef[ 'content-key' ][ $i ],
				'class'	=> $widgetDef[ 'content-value' ][ $i ],
			];
		}
	}
	$ret[ 'content' ] = $content;
	
	return $ret;
}

function createCheckboxList ( $widgetDef ) {
	$ret = createText( $widgetDef );
	
	$checkboxes = [];
	if ( isset( $widgetDef[ 'checkboxes-key' ] ) ) {
		foreach ( $widgetDef[ 'checkboxes-key' ] as $i => $null ) {
			if ( empty( $widgetDef[ 'checkboxes-key' ][ $i ] ) || empty( $widgetDef[ 'checkboxes-value' ][ $i ] ) ) {
				continue;
			}
			
			$checkboxes[] = [
				'label'	=> $widgetDef[ 'checkboxes-key' ][ $i ],
				'name'	=> $widgetDef[ 'checkboxes-value' ][ $i ],
			];
		}
	}
	$ret[ 'checkboxes' ] = $checkboxes;
	
	return $ret;
}

function createDateDouble ( $widgetDef ) {
	$ret = createText( $widgetDef );
	
	foreach ( [ 'label1', 'label2', 'name1', 'name2' ] as $field ) {
		if ( !empty( $widgetDef[ $field ] ) ) {
			$ret[ $field ] = $widgetDef[ $field ];
		}
	}
	
	return $ret;
}

function createP ( $widgetDef ) {
	return [
		'type'		=> $widgetDef[ 'widget' ],
		'content'	=> $widgetDef[ 'content' ],
	];
}

