function autocomplete ( target, arr ) {
	if ( !$( target ).data( 'url' ) ) {
		console.log( 'Autocomplete needs an attribute data-url', target );
		return;
	}
	
	var currentFocus,
		$target = $( target ),
		postParams = $target.data( 'params' ) ? $target.data( 'params' ) : {},
		autocompletUrl = $target.data( 'url' ),
		timer = null;
	
	$target.on( 'input', function ( e ) {
		// temporisation : if the field changed during last 100ms, do not launch AJAX request.
		if ( timer != null ) {
			clearTimeout( timer );
		}
		closeAllLists();
		timer = setTimeout( launchSearch, 150 );
	} );
	
	function launchSearch () {
		var val = $target.val(),
			searchParams = postParams;
		searchParams[ 'search' ] = val;
		
		closeAllLists();
		if ( !val ) {
			return false;
		}
		
		$.post( autocompletUrl, searchParams, function ( response, success ) {
			closeAllLists();
			currentFocus = -1;
			var id = $target.attr( 'id' ) + 'autocomplete-list',
				a = $( '<div id="' + id + '" class="autocomplete-items hide"></div>' );
			$target.parent().append( a );
			
			for ( var i = 0, iMax = response.length ; i < iMax ; i++ ) {
				var b = $( '<div><strong>' + response[ i ][ 'label' ] + '</strong></div>' );
				$( a ).append( b );
				
				for ( var j in response[ i ] ) {
					b.data( j, response[ i ][ j ] );
				}
				
				if ( $target.data( 'search-callback' ) ) {
					var callbackFunc = $target.data( 'search-callback' );
					if ( !window[ callbackFunc ] ) {
						console.log( 'Error : the "' + callbackFunc + '" function must be declared in the global scope.' )
					} else {
						window[ callbackFunc ]( response, $target );
					}
				}
				
				b.on( 'click', function ( e ) {
					$target.val( $( this ).data( 'label' ) );
					
					for ( var i in $( this ).data() ) {
						if ( $target.data( 'field-' + i ) ) {
							$( $target.data( 'field-' + i ) ).val( $( this ).data( i ) )
						}
					}
					
					if ( $target.data( 'change-callback' ) ) {
						var callbackFunc = $target.data( 'change-callback' );
						if ( !window[ callbackFunc ] ) {
							console.log( 'Error : the "' + callbackFunc + '" function must be declared in the global scope.' )
						} else {
							window[ callbackFunc ]( $( this ).data(), $( this ), $target );
						}
					}
					
					closeAllLists();
					a.remove();
				} );
			}
			
			$( '#' + id ).removeClass( 'hide' );
		} );
	}
	
	$target.on( 'keydown', function ( e ) {
		var x = document.getElementById( $( this ).attr( 'id' ) + 'autocomplete-list' );
		if ( x ) {
			x = x.getElementsByTagName( 'div' );
		} else {
			return;
		}
		
		if ( e.keyCode === 40 ) {
			// down
			currentFocus++;
			addActive( x );
		} else if ( e.keyCode === 38 ) {
			//up
			currentFocus--;
			addActive( x );
		} else if ( e.keyCode === 13 ) {
			// enter
			e.preventDefault();
			if ( currentFocus > -1 ) {
				if ( x ) {
					x[ currentFocus ].click();
				}
			}
		}
	} );

	function addActive ( x ) {
		if ( !x ) {
			return false;
		}
		
		removeActive( x );
		if ( currentFocus >= x.length ) {
			currentFocus = 0;
		}
		if ( currentFocus < 0 ) {
			currentFocus = ( x.length - 1 );
		}
		
		$( x[ currentFocus ] ).addClass( 'autocomplete-active' );
	}

	function removeActive ( x ) {
		for ( var i = 0, iMax = x.length ; i < iMax ; i++ ) {
			$( x[ i ] ).removeClass( 'autocomplete-active' );
		}
	}

	function closeAllLists ( elmnt ) {
		$( '.autocomplete-items' ).remove();
	}
	
	document.addEventListener( 'click', function ( e ) {
		closeAllLists( e.target );
	});
}
