var exportVars = ( function ( $, document, window ) {
	$( document ).ready(function() {
		initDragNDrop();
	} );
	
	var draggedElement = null,
		placeholder = $( '<div class="drag-placeholder"></div>' ),
		startY, startHeight, startScroll;
	
	function initDragNDrop () {
		$( '.demo-form-container' ).off( 'mousedown' )
		
		$( '.demo-form-container .btn-widget-move' ).each( function () {
			if ( $( this ).hasClass( 'init-drag-n-drop' ) ) {
				return;
			}
			$( this ).addClass( 'init-drag-n-drop' ).on( 'mousedown', function( e ) {
				e.preventDefault();
				draggedElement = $( this ).closest( '.widget-container' );
				startY = e.pageY;
				startHeight = draggedElement.outerHeight( true );
				startScroll = $( window ).scrollTop() + 100;
				
				placeholder.height( startHeight );
				draggedElement.after( placeholder );
				draggedElement.addClass( 'dragging' );
				draggedElement.css( 'width', draggedElement.width() + 'px' );
				
				$( document )
					.off( 'mousemove' ).on( 'mousemove', onMouseMove )
					.off( 'mouseup' ).on( 'mouseup', onMouseUp );
			}  );
		} );
	}
	
	function onMouseMove ( e ) {
		if ( !draggedElement ) {
			return;
		}
		
		var deltaY = e.pageY - startY,
			scrollDiff = $( window ).scrollTop() - startScroll;
		deltaY += scrollDiff;
		
		draggedElement.css( 'transform', `translateY(${deltaY}px)` );
		
		var placeholderIndex = getPlaceholderIndex( e.pageY );
		movePlaceholder( placeholderIndex );
	}
	
	function onMouseUp () {
		if ( !draggedElement ) {
			return;
		}
		
		draggedElement.removeClass( 'dragging' );
		draggedElement.css( {
			'transform': '',
			'width': ''
		} );
		
		placeholder.replaceWith( draggedElement );
		handleNestedContainers();
		
		$( document ).off( 'mousemove', onMouseMove ).off( 'mouseup', onMouseUp );
		
		if ( draggedElement.parents( '.widget-container' ).length > 0 ) {
			draggedElement.addClass( 'ml-7' ).data( 'ischild', true );
		} else {
			draggedElement.removeClass( 'ml-7' ).removeData( 'ischild' ).removeAttr( 'data-ischild' );
		}
		
		draggedElement = null;
		reinitForm();
	}
	
	function getPlaceholderIndex ( y ) {
		var widgets = $( '.widget-container:not(.dragging)' ),
			closestIndex = -1,
			closestDistance = Infinity;
		
		widgets.each( function( index ) {
			var widgetTop = $( this ).offset().top
				widgetBottom = widgetTop + $( this ).outerHeight()
				distance = Math.min( Math.abs( y - widgetTop ), Math.abs( y - widgetBottom ) );
			
			if ( distance < closestDistance ) {
				closestDistance = distance;
				closestIndex = index;
			}
		});
		
		return closestIndex;
	}
	
	function movePlaceholder ( index ) {
		var widgets = $( '.widget-container:not(.dragging)' );
		if ( index === -1 ) {
			widgets.first().before( placeholder );
		} else if ( index === widgets.length ) {
			widgets.last().after( placeholder );
		} else {
			widgets.eq( index ).before( placeholder );
		}
	}
	
	function handleNestedContainers () {
		$( '.widget-container[data-has-children="true"]' ).each( function () {
			var $parent = $( this ),
				$children = $parent.nextUntil( ':not(.widget-container)' );
			$parent.append( $children );
		});
	}
	
	return {
		'initDragNDrop' : initDragNDrop
	};
} )( $, document, window );

for ( var i in exportVars ) {
	window[ i ] = exportVars[ i ];
}
