Object.entries( ( function ( $, document, window ) {
	$( document ).ready( function () {
		initForm( $( 'body' ) );
	} );
	
	function initForm ( container ) {
		initTabindex( container );
		initDatepicker( container );
		initAutocomplete( container );
		initShowHide( container );
		initSelectPicker( container );
		initTinyMCE( container );
		initPopover( container );
		initNumeric( container );
	}
	
	function initTabindex ( container ) {
		$( '[tabindex]', container ).removeAttr( 'tabindex' );
		
		var maxTabindex = 0;
		$( '[tabindex]' ).each( function () {
			var ti = parseInt( $( this ).attr( 'tabindex' ) );
			if ( maxTabindex < ti ) {
				maxTabindex = ti;
			}
		} );
		maxTabindex++;
		
		$( 'input:not([type="hidden"]), select, textarea', container ).each( function ( i ) {
			$( this ).attr( 'tabindex', maxTabindex + i + 1 );
		} );
		
		$( 'input:not([type="hidden"]), select, textarea', container ).first().focus();
	}
	
	function initDatepicker ( container ) {
		$.fn.datepicker.dates[ 'fr' ] = {
			'days' : [ 'Dimanche', 'Lundi', 'Mardi', 'Mercredi', 'Jeudi', 'Vendredi', 'Samedi' ],
			'daysShort' : [ 'Dim.', 'Lun.', 'Mar.', 'Mer.', 'Jeu.', 'Ven.', 'Sam.' ],
			'daysMin' : [ 'd', 'l', 'ma', 'me', 'j', 'v', 's' ],
			'months' : [ 'Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre' ],
			'monthsShort' : [ 'Janv.', 'Févr.', 'Mars', 'Avril', 'Mai', 'Juin', 'Juil.', 'Août', 'Sept.', 'Oct.', 'Nov.', 'Déc.' ],
			'today' : 'Aujourd\'hui',
			'monthsTitle' : 'Mois',
			'clear' : 'Effacer',
			'weekStart' : 1,
			'format' : 'dd/mm/yyyy'
		};
		
		$( '.datepicker', container ).datepicker( {
			autoclose	: true,
			defaultDate	: new Date(),
			language: 'fr'
		} ).attr( 'autocomplete', 'new-password' );
	}
	
	function initAutocomplete ( container ) {
		$( '.autocomplete', container ).each( function () {
			autocomplete( this );
		} );
	}
	
	function initShowHide ( container ) {
		$( '[data-show-field][data-show-value]', container ).each( function () {
			var target = $( this );
			$( '[name="' + target.data( 'show-field' ) + '"]' ).change( function () {
				if ( ( $( this ).prop( 'type' ) == 'radio' ) && ( !$( this ).prop( 'checked' ) && ( $( '[name="' + target.data( 'show-field' ) + '"]:checked' ).length != 0 ) ) ) {
					return;
				}
				if ( $( this ).prop( 'type' ) == 'checkbox' ) {
					if ( !$( this ).prop( 'checked' ) ) {
						target.hide();
						return;
					} else {
						target.show();
						return;
					}
				}
				
				var showVals = target.data( 'show-value' );
				if ( typeof showVals === 'string' ) {
					showVals = [ showVals ];
				} else if ( typeof showVals === 'number' ) {
					showVals = [ "" + showVals ];
				} else if ( typeof showVals === 'object' ) {
					showVals = Object.values( showVals );
				}
				
				if ( showVals.indexOf( $( this ).val() ) != -1 ) {
					target.show();
					return;
				}
				
				target.hide();
			} ).change();
		} );
	}
	
	function initSelectPicker ( container ) {
		$( '.select-picker', container ).selectpicker();
	}
	
	function initTinyMCE ( container ) {
		$( '.tinymce', container ).each( function () {
			var $this = $( this );
			if ( $this.hasClass( 'has-tinymce' ) ) {
				return;
			}
			
			$this.addClass( 'has-tinymce' ).tinymce( {
				'plugins'						: 'quickbars',
				'menubar'						: false,
				'toolbar'						: false,
				'verify_html'					: false,
				'importcss_append'				: false,
				'quickbars_insert_toolbar'		: false,
				'quickbars_image_toolbar'		: false,
				'statusbar'						: false,
				'branding'						: false,
				'height'						: '150px',
				'width'							: 'calc(100% - 30px)',
				'quickbars_selection_toolbar'	: 'bold italic underline | alignleft aligncenter alignright alignjustify | quicklink h2 h3 h4 blockquote',
			} );
		} );
	}
	
	function initPopover ( container ) {
		$( '[data-bs-toggle="tooltip"]', container ).tooltip();
	}
	
	function initNumeric ( container ) {
		$( '.in-num', container ).on( 'input', function ( e ) {
			if ( !/^\d$/.test( e.originalEvent[ 'data' ] ) ) {
				$( this ).val( $( this ).val().slice( 0, -1 ) );
			}
		} );
		
		$( '.input-spinner span' ).click( function () {
			var $input = $( this ).parents( '.input-spinner' ).find( 'input.in-num' );
			if ( Number.isNaN( parseFloat( $input.val() ) )  ) {
				$input.val( 0 );
			}
			if ( $( this ).hasClass( 'minus' ) ) {
				var count = parseFloat( $input.val() ) - 1;
				count = ( count < 1 ) ? 1 : count;
				if ( count < 2 ) {
					$( this ).addClass( 'dis' );
				} else {
					$( this ).removeClass( 'dis' );
				}
				$input.val( count );
			} else {
				var count = parseFloat( $input.val() ) + 1;
				$input.val( count );
				if ( count > 1 ) {
					$( this ).parents( '.input-spinner' ).find( '.minus' ).removeClass( 'dis' );
				}
			}
			$input.change();
			return false;
		} );
	}
	
	function submitForm ( form, params, successCallback, errorCallback, options ) {
		var $form = $( form ),
			url = $form.attr( 'action' ),
			form = new FormData( $form[ 0 ] );
		
		for ( var a in params ) {
			form.append( a, params[ a ] );
		}
		
		$.ajax( {
			'url'			: url,
			'data'			: form,
			'type'			: 'POST',
			'processData'	: false,
			'contentType'	: false,
			'success'		: function ( response, success ) {
				if ( !options || !options[ 'noscroll' ] ) {
					window.scrollTo( 0, 0 );
				}
				$( '.alert-save-form' ).remove();
				
				if ( success !== 'success' ) {
					$form.prepend( getError( 'Une erreur est survenue pendant l\'enregistrement. Veuillez réessayer ultérieurement.' ) );
					if ( errorCallback ) {
						errorCallback( response );
					}
					return;
				}
				if ( response[ 'status' ] === 'error' ) {
					if ( response[ 'errors' ] ) {
						var html = 'Erreurs :<ul>';
						for ( var a in response[ 'errors' ] ) {
							html += '<li>' + response[ 'errors' ][ a ] + '</li>';
						}
						html += '</ul>';
						$form.prepend( getError( html ) );
					}
					if ( errorCallback ) {
						errorCallback( response );
					}
					return;
				}
				
				$form.prepend( getSuccess( 'Formulaire enregistré avec succès' ) );
				if ( successCallback ) {
					successCallback( response );
				}
				setTimeout( function () {
					$( '.alert-save-form.alert-success' ).fadeOut();
				}, 3000 );
			}
		} );
	}
	
	function getError ( text ) {
		return '<div class="alert alert-warning alert-save-form">\
					<button type="button" class="btn-close" data-close-target="#alert-info" data-dismiss="alert" aria-label="Fermer le bandeau d\'alerte"> <i class="far fa-times" aria-hidden="true"></i></button>\
					' + text + '\
				</div>';
	}
	
	function getSuccess ( text ) {
		return '<div class="alert alert-success alert-save-form">\
					<button type="button" class="btn-close" data-close-target="#alert-info" data-dismiss="alert" aria-label="Fermer le bandeau d\'alerte"> <i class="far fa-times" aria-hidden="true"></i></button>\
					' + text + '\
				</div>';
	}
	
	return {
		'initForm'		: initForm,
		'initTabindex'	: initTabindex,
		'submitForm'	: submitForm,
		'getError'		: getError,
		'getSuccess'	: getSuccess
	};
} )( $, document, window ) ).forEach( function ( params ) {
	window[ params[ 0 ] ] = params[ 1 ];
} );
