Object.entries(  ( function ( $, document, window ) {
	$( document ).ready( function () {
		initSearchWidgetList();
		initAddWidget();
		initBtnExport();
		initBtnExportHtml();
		initBtnImport();
		initBtnDemo();
		initChildrenBlocks();
		
		$( '.btn-submit-import' ).click();
	} );
	
	function reinitForm () {
		initChildrenBlocks();
		initDragNDrop();
		initWidgetBtns();
		initForm( '.demo-form-container' );
	}
	
	function initSearchWidgetList () {
		$( '.search-widget' ).on( 'input', function () {
			var searchText = $( this ).val().toLowerCase();
			$( '.new-widget' ).show().each( function () {
				if ( !$( this ).text().toLowerCase().includes( searchText ) ) {
					$( this ).hide();
				}
			} );
		} );
	}
	
	function initAddWidget () {
		$( '.new-widget' ).click( function () {
			var params = {
				'method'	: 'index',
				'action'	: 'get-widget-form',
				'id-widget'	: $( this ).data( 'id-widget' )
			};
			
			$.post( 'index.php', params, function ( response ) {
				$( '.modal-edit-widget .modal-title' ).html( response[ 'label' ] );
				$( '.modal-edit-widget .modal-body' ).html( response[ 'content' ] );
				initPhpInterface( $( '.modal-edit-widget' ) );
				
				$( '.modal-edit-widget .btn-submit-widget' ).off( 'click' ).click( submitAddForm );
				$( '.modal-edit-widget' ).modal( 'show' );
				initForm( $( '.modal-edit-widget' ) );
			} );
		} );
	}
	
	function submitAddForm () {
		var params = {
			'method'	: 'index',
			'action'	: 'create-row'
		};
		
		submitForm( $( '.modal-edit-widget form.modal-body' )[ 0 ], params, function ( response ) {
			if ( response[ 'status' ] === 'success' ) {
				var tpl = $( '.widget-container-ghost' ).clone( true, true ).removeClass( 'widget-container-ghost' );
				tpl.data( 'json', JSON.parse( response[ 'json' ] ) );
				$( '.content', tpl ).html( response[ 'content' ] );
				$( '.widget-title', tpl ).html( '<img src="imgs/subdirectory.svg" class="subitem-img"><span>' + response[ 'type' ] + '</span>' );
				$( '.demo-form-container' ).append( tpl );
				reinitForm();
				$( '.modal-edit-widget' ).modal( 'hide' );
			}
		} );
	}
	
	function initWidgetBtns () {
		function widgetRemove () {
			var $this = $( this );
			$( '.btn-confirm-remove-widget' ).off( 'click' ).click( function () {
				$this.parents( '.widget-container' ).first().remove();
				$( '.modal-confirm-remove-widget' ).modal( 'hide' );
				reinitForm();
				resetWidgetNames();
			} );
			$( '.modal-confirm-remove-widget' ).modal( 'show' );
			
		}
		
		function widgetEdit () {
			var $widgetContainer = $( this ).parents( '.widget-container' ).first(),
				params = {
					'method'	: 'index',
					'action'	: 'edit-widget',
					'json'		: $widgetContainer.data( 'json' )
				},
				html = '';
			
			if ( $( '.widget-container', $widgetContainer ).length > 0 ) {
				html = $( $( '.content', $widgetContainer ).first() ).clone( true, true );
				$('.ghost-children-container' ).remove();
			}
			
			$.post( 'index.php', params, function ( response ) {
				$( '.modal-edit-widget .modal-title' ).html( response[ 'label' ] );
				$( '.modal-edit-widget .modal-body' ).html( response[ 'content' ] );
				initForm( $( '.modal-edit-widget' ) );
				initPhpInterface( $( '.modal-edit-widget' ) );
				
				$( '.modal-edit-widget .btn-submit-widget' ).off( 'click' ).click( function () {
					submitEditForm( $widgetContainer, html );
				} );
				$( '.modal-edit-widget' ).modal( 'show' );
			} );
		}
		
		function widgetUp () {
			var current = $( this ).parents( '.widget-container' ).first(),
				previous = current.prev();
			
			if ( previous.length ) {
				current.insertBefore( previous );
			}
			initWidgetBtns();
		}
		
		function widgetDown () {
			var current = $( this ).parents( '.widget-container' ).first(),
				next = current.next();
			
			if ( next.length ) {
				next.insertBefore( current );
			}
			initWidgetBtns();
		}
		
		function submitEditForm ( $widgetContainer, html ) {
			var params = {
				'method'	: 'index',
				'action'	: 'create-row'
			};
			
			submitForm( $( '.modal-edit-widget form.modal-body' )[ 0 ], params, function ( response ) {
				if ( response[ 'status' ] === 'success' ) {
					var tpl = $( '.widget-container-ghost' ).clone( true, true ).removeClass( 'widget-container-ghost' );
					tpl.data( 'json', JSON.parse( response[ 'json' ] ) );
					$( '.content', tpl ).html( response[ 'content' ] );
					$( '.widget-title', tpl ).html( '<img src="imgs/subdirectory.svg" class="subitem-img"><span>' + response[ 'type' ] + '</span>'  );
					$widgetContainer.replaceWith( tpl );
					$( html ).insertAfter( tpl );
					
					reinitForm();
					resetWidgetNames();
					$( '.modal-edit-widget' ).modal( 'hide' );
				}
			}, function () {}, { 'noscroll' : true } );
		}
		
		$( '.demo-form-container .btn-widget-remove' ).off( 'click' ).click( widgetRemove );
		$( '.demo-form-container .btn-widget-edit' ).off( 'click' ).click( widgetEdit );
		$( '.demo-form-container .btn-widget-up' ).removeClass( 'disabled' ).off( 'click' ).click( widgetUp );
		$( '.demo-form-container .btn-widget-down' ).removeClass( 'disabled' ).off( 'click' ).click( widgetDown );
		
		$( '.widget-container:not(.widget-container-ghost)' ).each( function () {
			if ( $( this ).parents( '.widget-container:not(.widget-container-ghost)' ).length === 0 ) {
				if ( $( '.widget-container:not(.widget-container-ghost)', $( this ).parent() ).first().is( this ) ) {
					$( '.btn-widget-up', this ).off( 'click' ).addClass( 'disabled' );
				}
				if ( $( '.widget-container:not(.widget-container-ghost)', $( this ).parent() ).last().is( this ) ) {
					$( '.btn-widget-down', this ).off( 'click' ).addClass( 'disabled' );
				}
			} else {
				if ( $( '.widget-container:not(.widget-container-ghost)', $( this ).parent() ).first().is( this ) ) {
					$( '.btn-widget-up', this ).off( 'click' ).addClass( 'disabled' );
				}
				if ( $( '.widget-container:not(.widget-container-ghost)', $( this ).parent() ).last().is( this ) ) {
					$( '.btn-widget-down', this ).off( 'click' ).addClass( 'disabled' );
				}
			}
		} );
		
		$( '.widget-container' ).each( function () {
			var $this = $( this ),
				reduceBtn = $( '.btn-widget-reduce', this ).first();
			reduceBtn.off( 'click' ).click( function () {
				$( '.card-body', $this ).first().toggle();
				if ( $( '.card-body', $this ).first().is( ':visible' ) ) {
					$( 'i', reduceBtn ).removeClass( 'fa-plus' ).addClass( 'fa-minus' );
				} else {
					$( 'i', reduceBtn ).removeClass( 'fa-minus' ).addClass( 'fa-plus' );
				}
			} );
		} );
		
		$( '.btn-widget-reduce-all' ).off( 'click' ).click( function () {
			if ( $( 'i', this ).hasClass( 'fa-minus' ) ) {
				$( 'i', this ).removeClass( 'fa-minus' ).addClass( 'fa-plus' );
				$( '.widget-container .card-body:visible' ).each( function () {
					$( '.btn-widget-reduce i', $( this ).parent() ).first().click();
				} );
			} else {
				$( 'i', this ).removeClass( 'fa-plus' ).addClass( 'fa-minus' );
				$( '.widget-container .card-body:hidden' ).each( function () {
					$( '.btn-widget-reduce i', $( this ).parent() ).first().click();
				} );
			}
		} );
	}
	
	function initBtnExport () {
		$( '.btn-export' ).off( 'click' ).click( function () {
			var params = {
				'method'			: 'index',
				'action'			: 'export',
				'class-associee'	: $( '[name="class-associee"]' ).first().val(),
				'json'				: getJson( $( '.demo-form-container>.widget-container' ) )
			};
			
			$.post( 'index.php', params, function ( response ) {
				$( '.export-content' ).val( response[ 'content' ] );
				$( '.modal-export' ).modal( 'show' );
			} );
		} );
	}
	
	function initBtnExportHtml () {
		$( '.btn-export-html' ).off( 'click' ).click( function () {
			var params = {
				'method'			: 'index',
				'action'			: 'export-html',
				'class-associee'	: $( '[name="class-associee"]' ).first().val(),
				'json'				: getJson( $( '.demo-form-container>.widget-container' ) )
			};
			
			$.post( 'index.php', params, function ( response ) {
				$( '.export-content' ).val( response[ 'content' ] );
				$( '.modal-export-html' ).modal( 'show' );
			} );
		} );
	}
	
	function getJson ( nodes ) {
		var containerJSon = [];
		nodes.each( function () {
			var $this = $( this ),
				json = $this.data( 'json' );
			if ( json != undefined && json[ 'children' ] ) {
				delete json[ 'children' ];
			}
			if ( json != undefined && json[ 'json' ] ) {
				delete json[ 'json' ];
			}
			
			var $content = $( '.content', $this ).first(),
				$children = $( '>.widget-container', $content );
			if ( $children.length > 0 ) {
				json[ 'children' ] = getJson( $children );
			}
			
			containerJSon.push( json );
		} );
		
		return containerJSon;
	}
	
	function initBtnImport () {
		$( '.btn-submit-import' ).off( 'click' ).click( function () {
			var params = {
				'method'	: 'index',
				'action'	: 'import',
				'json'		: $( '.import-content' ).val()
			};
			
			$.post( 'index.php', params, function ( response ) {
				$( '[name="class-associee"]' ).val( response[ 'class-associee' ] );
				
				$( '.demo-form-container' ).empty();
				for ( var i in response[ 'content' ] ) {
					printWidget( response[ 'content' ][ i ], $( '.demo-form-container' ), false, response[ 'content' ] );
				}
				
				reinitForm();
				$( '.modal-import' ).modal( 'hide' );
			} );
		} );
	}
	
	/* print widget name */
	function resetWidgetNames () {
		var allJsons = getJson( $( '.demo-form-container>.widget-container' ) );
		
		function getJsons ( allJsons ) {
			for ( var i in allJsons ) {
				if ( allJsons[ i ] != undefined ) {
					allJsons[ i ][ 'json' ] = JSON.stringify( allJsons[ i ] );
					if ( allJsons[ i ][ 'children' ] ) {
						var children = allJsons[ i ][ 'children' ].filter( function( element ) {
							return element !== undefined;
						} );
						if ( children.length > 0 ) {
							var children = getJsons( allJsons[ i ][ 'children' ] );
							allJsons[ i ][ 'children' ] = children;
						}
					}
				}
			}
			return allJsons;
		}
		allWidgets = getJsons( allJsons );
		
		$( '.demo-form-container .widget-container' ).each( function () {
			var widgetTitle = getWidgetTitle( $( this ).data( 'json' ), allWidgets );
			$( '.widget-title', this ).html( '<img src="imgs/subdirectory.svg" class="subitem-img"><span>' + widgetTitle + '</span>' );
		} );
	}
	
	function printWidget ( widget, container, isChild, allWidgets ) {
		var widgetTitle = getWidgetTitle( JSON.parse( widget[ 'json' ] ), allWidgets ),
			tpl = $( '.widget-container-ghost' ).clone( true, true ).removeClass( 'widget-container-ghost' );
		
		tpl.data( 'json', JSON.parse( widget[ 'json' ] ) );
		$( '.widget-title', tpl ).html( '<img src="imgs/subdirectory.svg" class="subitem-img"><span>' + widgetTitle + '</span>' );
		container.append( tpl );
		
		if ( widget[ 'children' ] ) {
			for ( var i in widget[ 'children' ] ) {
				printWidget( widget[ 'children' ][ i ], $( '.content', tpl ).first(), true, allWidgets );
			}
		} else {
			$( '.content', tpl ).html( widget[ 'content' ] );
		}
		
		if ( isChild ) {
			$( tpl ).addClass( 'ml-7' ).addClass( 'mr-3' );
		}
		
		$( '[data-show-field][data-show-value]', tpl ).each( function () {
			$( this ).removeAttr( 'data-show-field' ).removeAttr( 'data-show-value' );
		} );
	}
	
	function getWidgetTitle ( desc, allWidgets ) {
		var title = '<span class="ft-primary">';
		
		if ( ( desc != undefined ) && ( desc[ 'label' ] != undefined ) ) {
			title += desc[ 'label' ];
			if ( desc[ 'type' ] ) {
				title += ' / ' + desc[ 'type' ].toUpperCase();
			}
		} else {
			if ( ( desc != undefined ) && ( desc[ 'type' ] != undefined ) ) {
				title += desc[ 'type' ].toUpperCase();
			}
		}
		title += '</span>';
		
		if ( ( desc != undefined ) && ( desc[ 'attributes' ] != undefined ) && ( desc[ 'attributes' ][ 'data-show-field' ] != undefined ) && ( desc[ 'attributes' ][ 'data-show-value' ] != undefined ) ) {
			var label = getWidgetLabel( desc[ 'attributes' ][ 'data-show-field' ], allWidgets );
			title += '<em class="ft-dynamic ml-2">(' + label + ' = ' + desc[ 'attributes' ][ 'data-show-value' ] + ')</em>';
		}
		
		return title;
	}
	
	function getWidgetLabel ( name, allWidgets ) {
		for ( var i in allWidgets ) {
			var json = {};
			if ( allWidgets[ i ][ 'json' ] ) {
				json = JSON.parse( allWidgets[ i ][ 'json' ] );
			} else {
				json = allWidgets[ i ];
			}
			
			if ( json[ 'name' ] && ( json[ 'name' ] === name ) ) {
				if ( json[ 'label' ] ) {
					return json[ 'label' ];
				} else {
					return json[ 'name' ];
				}
			}
			
			if ( json[ 'children' ] ) {
				var res = getWidgetLabel( name, json[ 'children' ] );
				if ( res !== '' ) {
					return res;
				}
			}
		}
		
		return '';
	}
	/* /print widget name */
	
	/* demo */
	var htmlPreview = '';
	function initBtnDemo () {
		$( '.preview-form-container-parentrow' ).hide();
		$( '.btn-preview' ).off( 'click' ).click( gotoPreview );
		$( '.btn-back-to-demo' ).off( 'click' ).click( gotoDemo );
	}
	
	function gotoPreview () {
		var params = {
			'method'			: 'index',
			'action'			: 'export-demo',
			'class-associee'	: $( '[name="class-associee"]' ).first().val(),
			'json'				: getJson( $( '.demo-form-container>.widget-container' ) )
		};
		
		$.post( 'index.php', params, function ( response ) {
			$( '.preview-form-container .preview-content' ).html( response[ 'content' ] );
			$( '.demo-form-container-parentrow, .btn-export, .btn-export-html, .btn-import, .class-container' ).hide();
			
			htmlPreview = $( '.demo-form-container' ).clone( true, true );
			$( '.demo-form-container' ).empty();
			$( '.preview-form-container-parentrow' ).show();
			$( '.btn-preview' ).off( 'click' ).click( gotoDemo );
			
			tinymce.remove( '.preview-form-container .preview-content .tinymce' );
			initForm( '.preview-form-container .preview-content' );
		} );
	}
	
	function gotoDemo () {
		$( '.demo-form-container' ).replaceWith( htmlPreview );
		setTimeout( function () {
			$( '.demo-form-container-parentrow' ).show();
		}, 100 );
		$( '.demo-form-container-parentrow, .btn-export, .btn-export-html, .btn-import, .class-container' ).show();
		$( '.btn-preview' ).off( 'click' ).click( gotoPreview );
		$( '.preview-form-container-parentrow' ).hide();
		initWidgetBtns();
	}
	/* /demo */
	
	/* children */
	function initChildrenBlocks () {
		// ghost children = drop zone :
		$( '.ghost-child' ).remove();
		$( '[data-has-children="true"]' ).each( function () {
			var $parent = $( this ).parents( '.widget-container' ).first();
			if ( $( '.widget-container', $parent ).length === 0 ) {
				$( '<div class="widget-container ghost-child"></div>' ).insertAfter( this );
			}
		} );
		
	}
	/* /children */
	
	return {
		'reinitForm' : reinitForm
	};
} )( $, document, window ) ).forEach( function ( params ) {
	window[ params[ 0 ] ] = params[ 1 ];
} );
