Object.entries(  ( function ( $, document, window ) {
	$( document ).ready( function () {
		initPhpInterface( $( 'body' ) );
	} );
	
	function initPhpInterface ( container ) {
		initMultipleKeyValue( container );
	}
	
	function initMultipleKeyValue ( container ) {
		$( '.multiple-key-values', container ).each( function () {
			initMultipleKeyValueElement( this );
		} );
	}
	
	function initMultipleKeyValueElement ( container ) {
		var $container = $( container );
		
		function lineRemove () {
			$( this ).parents( '.key-value-line' ).remove();
			initBtns();
		}
		
		function lineUp () {
			var $line = $( this ).parents( '.key-value-line' ),
				$prevLine = $line.prev( '.key-value-line' );
			if ( $prevLine.length > 0 ) {
				$prevLine.insertAfter( $line );
			}
			initBtns();
		}
		
		function lineDown () {
			var $line = $( this ).parents( '.key-value-line' ),
				$nextLine = $line.next( '.key-value-line' );
			if ( $nextLine.length > 0 ) {
				$nextLine.insertBefore( $line );
			}
			initBtns();
		}
		
		function lineAdd ( key, val ) {
			var tpl = $( '.form-row-ghost', $container ).clone().removeClass( 'form-row-ghost' );
			
			if ( key ) {
				$( '[data-role="key"]', tpl ).val( key );
			}
			if ( val ) {
				$( '[data-role="value"]', tpl ).val( val );
			}
			
			$( 'input[disabled]', tpl ).prop( 'disabled', false );
			$( '.show-container', $container ).append( tpl );
			
			initBtns();
		}
		
		function initBtns () {
			$( '.show-container .btn-line-up', $container ).removeClass( 'invisible' );
			$( '.show-container .btn-line-up', $container ).first().addClass( 'invisible' );
			
			$( '.show-container .btn-line-down', $container ).removeClass( 'invisible' );
			$( '.show-container .btn-line-down', $container ).last().addClass( 'invisible' );
			
			$( '.show-container .btn-line-add', $container ).addClass( 'invisible' );
			$( '.show-container .btn-line-add', $container ).last().removeClass( 'invisible' );
			
			if ( $( '.show-container .btn-line-remove', $container ).length === 1 ) {
				$( '.show-container .btn-line-remove', $container ).addClass( 'invisible' );
			} else {
				$( '.show-container .btn-line-remove', $container ).removeClass( 'invisible' );
			}
			$( '.show-container label.line-label', $container ).addClass( 'invisible' );
			$( '.show-container label.line-label', $container ).first().removeClass( 'invisible' );
			
			$( '.show-container .btn-line-remove, .show-container .btn-line-up, .show-container .btn-line-down, .show-container .btn-line-add', $container ).unbind( 'click' );
			
			$( '.show-container .btn-line-remove', $container ).click( lineRemove );
			$( '.show-container .btn-line-up', $container ).click( lineUp );
			$( '.show-container .btn-line-down', $container ).click( lineDown );
			$( '.show-container .btn-line-add', $container ).click( function () { lineAdd( '', '' ); } );
			
			initTabindex();
		}
		
		function initValues () {
			var vals = $container.data( 'value' );
			if ( ( vals !== '""' ) && ( vals !== '' ) && ( vals !== undefined ) && ( vals !== null ) ) {
				for ( i in vals ) {
					lineAdd( i, vals[ i ] );
					$( '.show-container .btn-line-up', $container ).last().click();
				}
			}
			
			initBtns();
		}
		
		initValues();
	}
	
	return {
		'initPhpInterface' : initPhpInterface
	};
} )( $, document, window ) ).forEach( function ( params ) {
	window[ params[ 0 ] ] = params[ 1 ];
} );
