tinymce.PluginManager.add( 'publipostage_switchTagsToValue', function( editor, url ) {
	// Add buttons
	var api1 = null;
	var api2 = null;
	
	editor.ui.registry.addToggleButton( 'switchTagsToValue_FUSION', {
		text: '<span class="switchTagsToValue_EDIT"><img src="/img/mode-edition.png"></span>',
		onAction: function ( api ) {
			if ( $( '[name="id_model"]' ).val() == '' ) {
				$( '.alerts' ).empty().append( '\
					<div class="alert alert-warning alert-modal-select-model">\
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">\
							<span aria-hidden="true">&times;</span>\
						</button>\
						<p>Vous devez d’abord sélectionner un modèle.</p>\
					</div>' );
				return;
			}
			if ( $( '[name="id_element"]' ).val() == '' ) {
				$( '.alerts' ).empty().append( '\
					<div class="alert alert-warning alert-modal-select-elements">\
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">\
							<span aria-hidden="true">&times;</span>\
						</button>\
						<p>Vous devez d’abord sélectionner un dossier.</p>\
					</div>' );
				return;
			}
			
			api1.setActive( true );
			api2.setActive( false );
			
			editor.setContent( fusionMode( editor.getContent() ) );
		},
		onSetup: function ( api ) {
			api1 = api;
			api.setActive( true );
		},
	} );
	
	editor.ui.registry.addToggleButton( 'switchTagsToValue_EDIT', {
		text: '<span class="switchTagsToValue_FUSION"><img src="/img/mode-fusion.png"></span>',
		onAction: function ( api ) {
			if ( $( '[name="id_model"]' ).val() == '' ) {
				$( '.alerts' ).empty().append( '\
					<div class="alert alert-warning alert-modal-select-model">\
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">\
							<span aria-hidden="true">&times;</span>\
						</button>\
						<p>Vous devez d’abord sélectionner un modèle.</p>\
					</div>' );
				return;
			}
			if ( $( '[name="id_element"]' ).val() == '' ) {
				$( '.alerts' ).empty().append( '\
					<div class="alert alert-warning alert-modal-select-elements">\
						<button type="button" class="close" data-dismiss="alert" aria-label="Close">\
							<span aria-hidden="true">&times;</span>\
						</button>\
						<p>Vous devez d’abord sélectionner un dossier.</p>\
					</div>' );
				return;
			}
			
			api2.setActive( true );
			api1.setActive( false );
			
			editor.setContent( editMode( editor.getContent() ) );
		},
		onSetup: function ( api ) {
			api2 = api;
		},
	} );
	
	function fusionMode ( content ) {
		var node = $( '<body></body>' );
		node.append( content );
		
		$( '.switch_tags', node ).each( function () {
			$( this ).text( '[' + $( this ).data( 'key' ) + ']' );
		} );
		
		var ret = node.html();
		node.remove();
		return ret;
	}
	
	function editMode ( content ) {
		var node = $( '<body></body>' );
		node.append( content );
		
		$( '.switch_tags', node ).each( function () {
			$( this ).html( $( this ).data( 'value' ) );
		} );
		
		var ret = node.html();
		node.remove();
		return ret;
	}
	
	
	// Adds a menu item, which can then be included in any menu via the menu/menubar configuration
	editor.ui.registry.addMenuItem( 'switchTagsToValue', {
		text: 'Example plugin',
		onAction: function() {
		},
	} );
	
	return {}
} );
