<?php
$attr = '';
if ( isset( $attributes, $attributes[ 'data-show-field' ], $attributes[ 'data-show-value' ] ) ) {
	$attr = ' data-show-field="' . str_replace( '"', '&quot;', $attributes[ 'data-show-field' ] ) . '" data-show-value="' . str_replace( '"', '&quot;', $attributes[ 'data-show-value' ] ) . '"';
	unset( $attributes[ 'data-show-field' ] );
	unset( $attributes[ 'data-show-value' ] );
}

$id = 'id-' . ( $name ?? '' );

if ( isset( $row_class ) ) {
	$row_class = ' ' . $row_class;
} else {
	$row_class = '';
}
$label_class = isset( $label_class ) ? ' class="col-sm-4 col-form-label text-end ' . trim( $label_class ) . '"' : ' class="col-sm-4 col-form-label text-end"';
?>
<div class="row align-items-center mb-3<?php echo $row_class; ?>"<?php echo $attr; ?>>
	<label<?php echo $label_class; ?> for="<?php echo $id; ?>"><?php
		echo ( $label ?? '' ) . '&nbsp;:';
		if ( isset( $mandatory ) && $mandatory === true ) {
			echo '&nbsp;<sup><i class="fas fa-asterisk text-danger"></i></sup>';
		}
	?></label>
	<div class="col-sm-8">
		<?php if ( isset( $prepend ) || isset( $append ) ): ?>
			<div class="input-group">
		<?php endif; ?>
			<?php if ( isset( $prepend ) ): ?>
				<span class="input-group-text"><?php echo $prepend; ?></span>
			<?php endif; ?>
			<?php
				$attr = '';
				if ( isset( $attributes ) ) {
					foreach ( $attributes as $attName => $attVal ) {
						if ( !is_string( $attVal ) && !is_numeric( $attVal ) ) {
							$attVal = json_encode( $attVal );
						}
						
						$attr .= ' ' . $attName . '="' . str_replace( '"', '&quot;', $attVal ) . '"';
					}
				}
				$val = formatDate( $this->getObjectValue( $name ?? '' ), 'Y-m-d', 'd/m/Y' );
				$input_class = isset( $input_class ) ? ' ' . trim( $input_class ) : '';
			?>
			<input type="text" class="form-control datepicker<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>" id="<?php echo $id; ?>"<?php echo $attr; ?> value="<?php echo htmlentities( $val ); ?>" placeholder="00/00/0000" size="10" maxlength="10">
			<?php if ( isset( $append ) ): ?>
				<span class="input-group-text"><?php echo $append; ?></span>
			<?php endif; ?>
		<?php if ( isset( $prepend ) || isset( $append ) ): ?>
			</div>
		<?php endif; ?>
	</div>
</div>
