
  <!-- CSS bootstrap-select compatible Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css" rel="stylesheet">

<?php

$attr = '';
if ( isset( $attributes, $attributes[ 'data-show-field' ], $attributes[ 'data-show-value' ] ) ) {
	$attr = ' data-show-field="' . str_replace( '"', '&quot;', $attributes[ 'data-show-field' ] ) . '" data-show-value="' . str_replace( '"', '&quot;', $attributes[ 'data-show-value' ] ) . '"';
	unset( $attributes[ 'data-show-field' ] );
	unset( $attributes[ 'data-show-value' ] );
}

if ( !isset( $values ) && isset( $dico ) ) {
	$dico = getDicoByName( $dico );
	$values = array_combine( array_column( $dico, 'dico_value' ), array_column( $dico, 'dico_label' ) );
} else if ( !isset( $values ) && !isset( $dico ) && isset( $callback_values ) ) {
	$values = $callback_values();
}

$id = 'id-' . $name;

if ( isset( $row_class ) ) {
	$row_class = ' ' . $row_class;
} else {
	$row_class = '';
}
$label_class = isset( $label_class ) ? ' class="col-sm-4 col-form-label text-end ' . trim( $label_class ) . '"' : ' class="col-sm-4 col-form-label text-end"';
?>
<div class="row<?php echo $row_class; ?>"<?php echo $attr; ?>>
	<label<?php echo $label_class; ?> id="<?php echo $id; ?>"><?php
		echo ( $label ?? '' ) . '&nbsp;:';
		if ( isset( $mandatory ) && $mandatory === true ) {
			echo '&nbsp;<sup><i class="fas fa-asterisk text-danger"></i></sup>';
		}
	?></label>
	<div class="col-sm-8">
		<?php
			$attr = '';
			if ( isset( $attributes ) ) {
				foreach ( $attributes as $attName => $attVal ) {
					if ( !is_string( $attVal ) && !is_numeric( $attVal ) ) {
						$attVal = json_encode( $attVal );
					}
					
					$attr .= ' ' . $attName . '="' . str_replace( '"', '&quot;', $attVal ) . '"';
				}
			}
			
			if ( isset( $title ) ) {
				$attr .= ' title="' . htmlentities( $title ) . '"';
			} else {
				if ( substr( $name, -2, 2 ) === '[]' ) {
					$attr .= ' title="Sélectionnez une ou plusieurs valeurs" multiple';
				} else {
					$attr .= ' title="Sélectionnez une valeur"';
				}
			}
			$input_class = isset( $input_class ) ? ' ' . trim( $input_class ) : '';
		?>
		<select class="form-control select-picker<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>" id="<?php echo $id; ?>"<?php echo $attr; ?> data-live-search="true" data-hide-disabled="true" data-size="17">
			<?php
				$val = $this->getObjectValue( $name );
			?>
			<?php foreach ( $values as $k => $v ): ?>
				<?php
					$selected = '';
					if ( $k === $val ) {
						$selected = ' selected';
					}
				?>
				<option value="<?php echo $k; ?>"<?php echo $selected; ?>><?php echo $v; ?></option>
			<?php endforeach; ?>
		</select>
	</div>
</div>
