<?php
$attr = '';
if ( isset( $attributes, $attributes[ 'data-show-field' ], $attributes[ 'data-show-value' ] ) ) {
	$attr = ' data-show-field="' . str_replace( '"', '&quot;', $attributes[ 'data-show-field' ] ) . '" data-show-value="' . str_replace( '"', '&quot;', $attributes[ 'data-show-value' ] ) . '"';
	unset( $attributes[ 'data-show-field' ] );
	unset( $attributes[ 'data-show-value' ] );
}

$id = 'id-' . $name ?? '';

if ( isset( $row_class ) ) {
	$row_class = ' ' . $row_class;
} else {
	$row_class = '';
}
$val = $this->getObjectValue( $name );

if ( !isset( $label1 ) ) {
	$label1 = 'Clé';
}
if ( !isset( $label2 ) ) {
	$label2 = 'Valeur';
}
$label_class = isset( $label_class ) ? ' class="' . trim( $label_class ) . '"' : '';
?>
<div class="multiple-key-values" data-value="<?php echo str_replace( '"', '&quot;', json_encode( $val ) ); ?>"<?php echo $attr; ?>>
	<div class="show-container">
		<label<?php echo $label_class; ?> class="line-label"><?php
			echo ( $label ?? '' ) . '&nbsp;:';
			if ( isset( $mandatory ) && $mandatory === true ) {
				echo '&nbsp;<sup><i class="fas fa-asterisk text-danger"></i></sup>';
			}
		?></label>
		<div class="key-value-line form-row<?php echo $row_class; ?>">
			<div class="control-group">
				<div class="input-group">
					<?php
						$fieldAttr = '';
						if ( isset( $attributes ) ) {
							foreach ( $attributes as $attName => $attVal ) {
								if ( !is_string( $attVal ) && !is_numeric( $attVal ) ) {
									$attVal = json_encode( $attVal );
								}
								
								$fieldAttr .= ' ' . $attName . '="' . str_replace( '"', '&quot;', $attVal ) . '"';
							}
						}
						
						if ( isset( $input_class ) ) {
							$input_class = ' ' . $input_class;
						} else {
							$input_class = '';
						}
					?>
					
					<label class="mt-2 ps-2 pe-2"><?php echo $label1; ?>&nbsp;:</label>
					<div class="input-group-auto mr-2">
						<input type="text" class="form-control<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>-key[]" <?php echo $fieldAttr; ?> data-role="key">
					</div>
					<label class="mt-2 ps-2 pe-2"><?php echo $label2; ?>&nbsp;:</label>
					<div class="input-group-auto mr-2">
						<input type="text" class="form-control<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>-value[]" <?php echo $fieldAttr; ?> data-role="value">
					</div>
					<div class="input-group-auto mr-2 ml-2 mt-2">
						<span class="input-group-text btn-primary d-inline btn-line-remove" role="button">
							<i class="far fa-trash-alt ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-up" role="button">
							<i class="fas fa-angle-up ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-down" role="button">
							<i class="fas fa-angle-down ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-add" role="button">
							<i class="fas fa-plus ft-secondary"></i>
						</span>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<!-- TEMPLATE FOR JS -->
	<div class="d-none">
		<div class="form-row-ghost key-value-line form-row<?php echo $row_class; ?>"<?php echo $attr; ?>>
			<div class="control-group">
				<div class="input-group">
					<label class="mt-2 ps-2 pe-2"><?php echo $label1; ?>&nbsp;:</label>
					<div class="input-group-auto mr-2">
						<input type="text" class="form-control<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>-key[]" <?php echo $fieldAttr; ?> data-role="key" disabled>
					</div>
					<label class="mt-2 ps-2 pe-2"><?php echo $label2; ?>&nbsp;:</label>
					<div class="input-group-auto mr-2">
						<input type="text" class="form-control<?php echo $input_class; ?>" name="<?php echo $name ?? ''; ?>-value[]" <?php echo $fieldAttr; ?> data-role="value" disabled>
					</div>
					<div class="input-group-auto mr-2 ml-2 mt-2">
						<span class="input-group-text btn-primary d-inline btn-line-remove" role="button">
							<i class="far fa-trash-alt ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-up" role="button">
							<i class="fas fa-angle-up ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-down" role="button">
							<i class="fas fa-angle-down ft-secondary"></i>
						</span>
						<span class="input-group-text ml-1 btn-primary d-inline btn-line-add" role="button">
							<i class="fas fa-plus ft-secondary"></i>
						</span>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- /TEMPLATE FOR JS -->
</div>

