<?php
$attr = '';
if ( isset( $attributes, $attributes[ 'data-show-field' ], $attributes[ 'data-show-value' ] ) ) {
	$attr = ' data-show-field="' . str_replace( '"', '&quot;', $attributes[ 'data-show-field' ] ) . '" data-show-value="' . str_replace( '"', '&quot;', $attributes[ 'data-show-value' ] ) . '"';
	unset( $attributes[ 'data-show-field' ] );
	unset( $attributes[ 'data-show-value' ] );
}

$id = isset( $name ) ? 'id-' . $name : 'id-' . self::getNextId();

if ( isset( $row_class ) ) {
	$row_class = ' ' . $row_class;
} else {
	$row_class = '';
}
$label_class = isset( $label_class ) ? ' class="' . trim( $label_class ) . '"' : '';
?>
<div class="form-row<?php echo $row_class; ?>"<?php echo $attr; ?>>
	<label<?php echo $label_class; ?> for="<?php echo $id; ?>"><?php
		echo ( $label ?? '' ) . '&nbsp;:';
		if ( isset( $mandatory ) && $mandatory === true ) {
			echo '&nbsp;<sup><i class="fas fa-asterisk text-danger"></i></sup>';
		}
	?></label>
	<div class="input-group">
		<?php if ( isset( $prepend ) ): ?>
			<span class="input-group-text"><?php echo $prepend; ?></span>
		<?php endif; ?>
		<?php
			$attr = '';
			if ( isset( $attributes ) ) {
				foreach ( $attributes as $attName => $attVal ) {
					if ( !is_string( $attVal ) && !is_numeric( $attVal ) ) {
						$attVal = json_encode( $attVal );
					}
					
					$attr .= ' ' . $attName . '="' . str_replace( '"', '&quot;', $attVal ) . '"';
				}
			}
			$val = $this->getObjectValue( $name??null );
			$input_class = isset( $input_class ) ? ' ' . trim( $input_class ) : '';
		?>
		<input class="form-control form-search autocomplete<?php echo $input_class; ?>" type="text"<?php
			echo isset( $name ) ? ' name="' . $name . '"' : '';
			echo ' id="' . $id . '"';
			echo $attr; ?>>
		<button class="btn btn-primary" onclick="this.parentNode.querySelectorAll( 'input' ).forEach( function ( n ) { n.value = ''; } ); return false;">
			<span>Effacer la recherche</span>
		</button>
		<?php if ( isset( $append ) ): ?>
			<span class="input-group-text"><?php echo $append; ?></span>
		<?php endif; ?>
	</div>
</div>
