<?php
$attr = '';
if ( isset( $attributes, $attributes[ 'data-show-field' ], $attributes[ 'data-show-value' ] ) ) {
	$attr = ' data-show-field="' . str_replace( '"', '&quot;', $attributes[ 'data-show-field' ] ) . '" data-show-value="' . str_replace( '"', '&quot;', $attributes[ 'data-show-value' ] ) . '"';
	unset( $attributes[ 'data-show-field' ] );
	unset( $attributes[ 'data-show-value' ] );
}

$id = 'id-' . $name1 ?? '';

if ( isset( $row_class ) ) {
	$row_class = ' ' . $row_class;
} else {
	$row_class = '';
}
$label_class = isset( $label_class ) ? ' class="' . trim( $label_class ) . '"' : '';
?>
<div class="form-row<?php echo $row_class; ?>"<?php echo $attr; ?>>
	<label<?php echo $label_class; ?> for="<?php echo $id; ?>"><?php
		echo ( $label ?? '' ) . '&nbsp;:';
		if ( isset( $mandatory ) && $mandatory === true ) {
			echo '&nbsp;<sup><i class="fas fa-asterisk text-danger"></i></sup>';
		}
	?></label>
	<div class="control-group">
		<?php
			$attr = '';
			if ( isset( $attributes ) ) {
				foreach ( $attributes as $attName => $attVal ) {
					if ( !is_string( $attVal ) && !is_numeric( $attVal ) ) {
						$attVal = json_encode( $attVal );
					}
					
					$attr .= ' ' . $attName . '="' . str_replace( '"', '&quot;', $attVal ) . '"';
				}
			}
			$val1 = formatDate( $this->getObjectValue( $name1 ), 'Y-m-d', 'd/m/Y' );
			$val2 = formatDate( $this->getObjectValue( $name2 ), 'Y-m-d', 'd/m/Y' );
			
			if ( !isset( $label1 ) ) {
				$label1 = 'Du';
			}
			if ( !isset( $label2 ) ) {
				$label2 = 'au';
			}
			$input_class = isset( $input_class ) ? ' ' . trim( $input_class ) : '';
		?>
		<div class="input-group">
			<span class="input-group-text"><?php echo $label1; ?></span>
			<input type="text" class="form-control datepicker<?php echo $input_class; ?>" placeholder="00/00/0000" size="10" maxlength="10" value="<?php echo htmlentities( $val1 ); ?>" name="<?php echo $name1; ?>" id="id-<?php echo $name1; ?>">
			<span class="input-group-text">
				<i class="fas fa-calendar-alt"></i>
			</span>
			<span class="input-group-text"><?php echo $label2; ?></span>
			<input type="text" class="form-control datepicker<?php echo $input_class; ?>" placeholder="00/00/0000" size="10" maxlength="10" value="<?php echo htmlentities( $val2 ); ?>" name="<?php echo $name2; ?>" id="id-<?php echo $name2; ?>">
			<span class="input-group-text">
				<i class="fas fa-calendar-alt"></i>
			</span>
		</div>
	</div>
</div>
